<?php

// phpinfo();
// https://github.com/mtdowling/cron-expression
/*
 * PHP Cron Expression Parser
 * The PHP cron expression parser can parse a CRON expression,
 * determine if it is due to run, calculate the next run date of the expression,
 * and calculate the previous run date of the expression.
 * You can calculate dates far into the future or past by skipping n number of matching dates.

 * The parser can handle increments of ranges (e.g. * /12, 2-59/3), intervals (e.g. 0-9),
 * lists (e.g. 1,2,3), W to find the nearest weekday for a given day of the month,
 * L to find the last day of the month, L to find the last given weekday of a month,
 * and hash (#) to find the nth weekday of a given month.

 * CRON Expressions
 * A CRON expression is a string representing the schedule for a particular
 * command to execute. The parts of a CRON schedule are as follows:

 *    *    *    *    *    *
  -    -    -    -    -    -
  |    |    |    |    |    |
  |    |    |    |    |    + year [optional]
  |    |    |    |    +----- day of week (0 - 7) (Sunday=0 or 7)
  |    |    |    +---------- month (1 - 12)
  |    |    +--------------- day of month (1 - 31)
  |    +-------------------- hour (0 - 23)
  +------------------------- min (0 - 59)
  Requirements
  PHP 5.3+
  PHPUnit is required to run the unit tests
  Phing is required to build the phar file
 */

date_default_timezone_set('Europe/Helsinki');

//require_once 'cron.phar';
  require("cron/CronExpression.php");
  require("cron/FieldFactory.php");
  require("cron/FieldInterface.php");
  require("cron/AbstractField.php");
  require("cron/SecondsField.php");
  require("cron/MinutesField.php");
  require("cron/HoursField.php");
  require("cron/DayOfWeekField.php");
  require("cron/DayOfMonthField.php");
  require("cron/MonthField.php");
  require("cron/YearField.php");


/*
$arrCronParam = array('* * * * *', '3-59/15 1,6-12 15 1 2-5', '@daily', '@weekly', '@monthly');
echo cron($arrCronParam) . "\n";
*/

unset($argv[0]); // clears cron.php from param array
//var_dump($argv);
echo cron($argv);

function cron($arrCron) {
	//return phpversion();
	$arrCronStr = array();
	$arrIsDue = array();
	$arrPreviousRunDate = array();
	$arrNextRunDate = array();
	$i = 0;
	$ruleStr = '';
	foreach ($arrCron as $cronRule) {
		$ruleStr = (string) $cronRule;
		//echo $ruleStr . "\n";
		$useSeconds = (substr_count($ruleStr, ' ') >= 5);
		if ($useSeconds === false){
			$ruleStr = "0 " . $ruleStr;
			echo $ruleStr . "\n";
		}
		$arrCronStr[$i] = $ruleStr;
		$cron = Cron\CronExpression::factory($ruleStr);
		$arrIsDue[$i] = (int) $cron->isDue();

		if (strpos($ruleStr, "/"))
			$arrPreviousRunDate[$i] = "-";
		else if (strncmp($ruleStr, "@", 1) >= 0)
			$arrPreviousRunDate[$i] = "--";
		else
			$arrPreviousRunDate[$i] = $cron->getPreviousRunDate()->format('Y-m-d H:i:s');

		$arrNextRunDate[$i] = $cron->getNextRunDate()->format('Y-m-d H:i:s');

		$i++;
	}

	$returnArr = array(
			'Cron' => $arrCronStr,
			'IsDue' => $arrIsDue,
			'PreviousRunDate' => $arrPreviousRunDate,
			'NextRunDate' => $arrNextRunDate
	);
	$returnJson = json_encode($returnArr) . "\n";
	return $returnJson;
}

?>